/*-------------------------------------------------------*
*  Name:      Easy Tools plug-in for ZModeler v1.04      *
*  Purpose:   Some handy tools that simplifies work in ZM*
*  Authors:   Oleg M.                                    *
*                                                        *
*  History:   7.sep.01 - project started                 *
*                                                        *
*-------------------------------------------------------*/
#include <Struct.h>
#include <3DEngine.h>
#include <afxcmn.h>
#include "resource.h"

CToolBar*  pBar  = NULL;
BOOL    EasySelectEnabled = FALSE;
BOOL    EasySelectReady = FALSE;
BOOL    IsRectShape;//if FALSE - circle shape
HCURSOR  hcRNorm,
    hcRShift,
    hcRCtrl,
    hcCNorm,
    hcCShift,
    hcCCtrl;
HCURSOR  hcNorm,
    hcShift,
    hcCtrl,
    hcLBNorm,
    hcLBShift,
    hcLBCtrl;


//////////////////////////////////////////////////////////////
//  DWORD Capabilities - a combination versions
DWORD CALLBACK Capabilities(long)
{
  return ZMODELER_BUILD_VERSION();
}


//////////////////////////////////////////////////////////////
//  DWORD Supports returns a combination of supported features
DWORD CALLBACK Supports(long)
{
  return Z3D_PLUGSUPPORTS_PROCESSING;
}

//////////////////////////////////////////////////////////////
//  BOOL DynamicLoading specifies whether the dll will be
//  loaded only when it's functions are needed.
//  You should NOT make it dynamic, if it is a processor-type.
DWORD CALLBACK DynamicLoading(long)
{
  return 0; // DLL will be loaded ones.
}

//////////////////////////////////////////////////////////////
//  DWORD GetProcsAmount returns a number of IDENTICAL procedu-
//  res that will be placed in the same folder. I think there is
//  No limitation here... (256 is enough;)
DWORD CALLBACK GetProcsAmount(DWORD)
{
  return 1;//one toolbar
}

//////////////////////////////////////////////////////////////
//  DWORD PlaceType returns a DWORD, that indicates, where the
//  plugin gode will be placed. It can be MenuBAR, MainMenu
DWORD CALLBACK PlaceType(DWORD num)
{
  return Z3D_PROCPLACE_TOOLBAR;
}

char* CALLBACK GetProcName(DWORD num)
{
  if (num==0) return "View Easy Tools";
  return NULL;
}

char* GetToolName(long num)
{
  if (num==0) return "Rect";
  if (num==1) return "Circ";
  return NULL;
}

char* CALLBACK GetProcComment(DWORD num)
{
  //Zoom, Pan, Fit
  return "Rectangle easy selector. Hold Shift for additional and Ctrl for subtractional selection\n"
    "Circular easy selector. Hold Shift for additional and Ctrl for subtractional selection\n";
}



//////////////////////////////////////////////////////////////
//  void OnLoad processes creation of the corresponding toolbar.
//  and attaching of it into the main window;
DWORD CALLBACK OnLoadToolBar(
            DWORD        num,
            CToolBar**      TB,
            CWnd        *pwnd,
            HINSTANCE      AppHandle,
            HINSTANCE      DLLHandle)
{
  z3dProcsSet  *pProcs = NULL;
  if (DLLHandle && pwnd)
  {
    pBar = new CToolBar();
    AfxSetResourceHandle(DLLHandle);// Tell system to use DLL's resources.
    CWinApp* pApp = AfxGetApp();
    if (pApp)
    {
      hcRNorm    = pApp->LoadCursor(IDC_RECTSEL);
      hcRShift  = pApp->LoadCursor(IDC_RECTADD);
      hcRCtrl    = pApp->LoadCursor(IDC_RECTSUB);
      hcCNorm    = pApp->LoadCursor(IDC_CIRCSEL);
      hcCShift  = pApp->LoadCursor(IDC_CIRCADD);
      hcCCtrl    = pApp->LoadCursor(IDC_CIRCSUB);
      hcNorm    = hArrowCursor;
      hcShift    = hArrowCursor;
      hcCtrl    = hArrowCursor;
      hcLBNorm  = hArrowCursor;
      hcLBShift  = hArrowCursor;
      hcLBCtrl  = hArrowCursor;
    }

    pBar->CreateEx(pwnd, TBSTYLE_FLAT, WS_CHILD | WS_VISIBLE | CBRS_TOP
            | CBRS_GRIPPER | CBRS_TOOLTIPS | CBRS_FLYBY | CBRS_SIZE_DYNAMIC);
    pBar->SetWindowText("View Easy Tools");
    if (!pBar->LoadToolBar(IDR_VIEWEASYTOOLS))
    {
      pwnd->MessageBox("Error Loading ToolBar in module ZEasyTools.zmp", "Plugin Error:", MB_OK | MB_ICONEXCLAMATION);
      delete pBar;
      pBar = NULL;
      return 0;
    }
    /////// Docking Control Bar
    pBar->EnableDocking(CBRS_ALIGN_ANY);
    
    int i;
    TBBUTTON Button;
    for (i=0; i < pBar->GetCount(); i++)
    {//Removing buttons
      (pBar->GetToolBarCtrl()).GetButton( i, &Button);
      (pBar->GetToolBarCtrl()).DeleteButton( i);
      pProcs = new z3dProcsSet;
      pProcs->DllHandleLB    = DLLHandle;
      pProcs->DllHandleRB    = DLLHandle;
      pProcs->bAlternative  = FALSE;
      pProcs->OnPreModeProc  = (PLUGPROCESSORPROC)GetProcAddress(DLLHandle, GetToolName(i)+CString("OnPreMode"));
      pProcs->OnPostModeProc  = (PLUGPROCESSORPROC)GetProcAddress(DLLHandle, GetToolName(i)+CString("OnPostMode"));

      Button.dwData = (DWORD)(pProcs);
      (pBar->GetToolBarCtrl()).InsertButton( i, &Button);
      pBar->SetButtonStyle(i,TBBS_CHECKBOX);
    }
  
    AfxSetResourceHandle(AppHandle);// Set it back before leaving.
  }
  else
  {
    pwnd->MessageBox("Resources not found or Editor window was not created!","Internal Error:", MB_OK | MB_ICONEXCLAMATION);
    pBar = NULL;
    return 0;
  }
  if (pBar) *TB = pBar;
  return 1; //ok, dockable;
}